/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.filechooser;

import de.javasoft.io.FileOperationEvent;
import de.javasoft.io.FileOperationListener;
import de.javasoft.io.FileProperties;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class FilePropertiesDialog
extends JDialog
implements FileOperationListener,
Runnable {
    private boolean abort;
    private long counter = 0L;
    private JLabel location;
    private JLabel files;
    private JLabel size;
    private JLabel date;
    private FileProperties props;
    private Color brightLabelColor;
    private Color labelColor;
    private static final int xGap = 10;
    private static final int yGap = 10;
    String title = "";
    String imagePath = "";
    Insets imageInsets;

    public FilePropertiesDialog(Dialog dialog) {
        super(dialog);
        this.init(dialog);
    }

    public FilePropertiesDialog(Frame frame) {
        super(frame);
        this.init(frame);
    }

    private void init(Window window) {
        Image image = null;
        this.title = UIManager.getString("FilePropertiesDialog.title");
        this.imagePath = UIManager.getString("Synthetica.filePropertiesDialog.title.background");
        this.imageInsets = SyntheticaLookAndFeel.getInsets("Synthetica.filePropertiesDialog.title.background.insets", null, new Insets(0, 0, 4, 100));
        image = (Image)UIManager.get("Synthetica.filePropertiesDialog.iconImage");
        this.setTitle(this.title);
        this.setLayout(new BorderLayout());
        this.getRootPane().putClientProperty("Synthetica.dialog.iconImage", image);
        JPanel jPanel = new JPanel(){
            private Image background;
            {
                this.background = new ImageIcon(SyntheticaLookAndFeel.class.getResource(FilePropertiesDialog.this.imagePath)).getImage();
            }

            public void paintComponent(Graphics graphics) {
                ImagePainter imagePainter = new ImagePainter(this.background, graphics, 0, 0, this.getWidth(), this.background.getHeight(null), FilePropertiesDialog.this.imageInsets, FilePropertiesDialog.this.imageInsets);
                imagePainter.draw();
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                int n = UIManager.getInt("Synthetica.filePropertiesDialog.title.xPos");
                int n2 = UIManager.getInt("Synthetica.filePropertiesDialog.title.yPos");
                graphics2D.drawString(FilePropertiesDialog.this.title, n, n2);
                graphics2D.dispose();
            }

            public Dimension getPreferredSize() {
                return new Dimension(this.background.getWidth(null), this.background.getHeight(null));
            }
        };
        float f = SyntheticaLookAndFeel.scaleFontSize(UIManager.getInt("Synthetica.filePropertiesDialog.title.size"));
        jPanel.setFont(jPanel.getFont().deriveFont(1, f));
        jPanel.setForeground(UIManager.getColor("Synthetica.filePropertiesDialog.title.color"));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.files = new JLabel("!");
        this.labelColor = this.files.getForeground();
        this.brightLabelColor = new Color(this.labelColor.getRGB() + 0x606060);
        this.files.setForeground(this.brightLabelColor);
        jPanel2.add((Component)this.files, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 2, 10);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        JLabel jLabel = new JLabel(UIManager.getString("FilePropertiesDialog.location"));
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.location = new JLabel();
        jPanel2.add((Component)this.location, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 2, 10);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        JLabel jLabel2 = new JLabel(UIManager.getString("FilePropertiesDialog.size"));
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.size = new JLabel();
        this.size.setForeground(this.brightLabelColor);
        jPanel2.add((Component)this.size, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 20, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        JLabel jLabel3 = new JLabel(UIManager.getString("FilePropertiesDialog.date"));
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.date = new JLabel();
        jPanel2.add((Component)this.date, gridBagConstraints);
        gridBagConstraints.anchor = window.getComponentOrientation().isLeftToRight() ? 13 : 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        JButton jButton = new JButton(UIManager.getString("FilePropertiesDialog.ok"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilePropertiesDialog.this.abort = true;
                FilePropertiesDialog.this.dispose();
            }
        });
        jButton.setMinimumSize(new Dimension(jButton.getPreferredSize().width * 2, jButton.getPreferredSize().height));
        jButton.setPreferredSize(jButton.getMinimumSize());
        jPanel2.add((Component)jButton, gridBagConstraints);
        this.add((Component)jPanel, "North");
        this.add(jPanel2);
        this.pack();
        int n = window.getLocation().x + window.getSize().width / 2;
        int n2 = n - this.getSize().width / 2;
        int n3 = window.getLocation().y + window.getSize().height / 2;
        int n4 = n3 - this.getSize().height / 2;
        this.setLocation(n2, n4);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FilePropertiesDialog.this.abort = true;
            }
        });
    }

    public boolean processFileOperationEvent(FileOperationEvent fileOperationEvent) {
        ++this.counter;
        this.props = (FileProperties)fileOperationEvent.getSource();
        if (this.counter % 100L == 0L || this.counter < 10L) {
            EventQueue.invokeLater(this);
        }
        return !this.abort;
    }

    public void run() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        String string = UIManager.getString("FilePropertiesDialog.filesFormat");
        String string2 = numberFormat.format(this.props.directories);
        String string3 = numberFormat.format(this.props.files);
        this.files.setText(MessageFormat.format(string, string3, string2));
        String string4 = UIManager.getString("FilePropertiesDialog.sizeFormat");
        String string5 = numberFormat.format(this.props.size);
        numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
        String string6 = numberFormat.format((double)this.props.size / 1024.0 / 1024.0);
        this.size.setText(MessageFormat.format(string4, string5, string6));
        this.location.setText(this.props.location);
        if (this.props.directories + this.props.files == 1L) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(UIManager.getString("FilePropertiesDialog.dateFormat"));
            this.date.setText(simpleDateFormat.format(new Date(this.props.lastModified)));
        } else {
            this.date.setText("---");
        }
    }

    public void refresh() {
        this.counter = 0L;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                FilePropertiesDialog.this.files.setForeground(FilePropertiesDialog.this.labelColor);
                FilePropertiesDialog.this.size.setForeground(FilePropertiesDialog.this.labelColor);
            }
        });
        EventQueue.invokeLater(this);
    }
}

